/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import mms.gfxedit.filter.ColorChannelBWFilter;
import mms.gfxedit.filter.ColorChannelFilter;
import mms.gfxedit.filter.ColorSaturationFilter;
import mms.gfxedit.filter.GaussianBlur;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.filter.HSBBrightnessFilter;
import mms.gfxedit.filter.HSBHueFilter;
import mms.gfxedit.filter.HSBSaturationFilter;
import mms.gfxedit.filter.InvertFilter;
import mms.gfxedit.filter.OpacityFilter;
import mms.gfxedit.filter.PosterizeFilter;
import mms.gfxedit.filter.RotateFilter;
import mms.gfxedit.filter.ScaleFilter;
import mms.gfxedit.filter.SelectiveBW;
import mms.gfxedit.filter.SimpleBlurFilter;
import mms.gfxedit.filter.UnsharpMaskFilter;
import mms.gfxedit.graphics.GraphicsCommand;
import mms.gfxedit.graphics.GraphicsObject;
import mms.gfxedit.gui.GraphicsEditorGUI;

public class GraphicsEditor {
    private Stack<GraphicsCommand> undo = new Stack();
    private Stack<GraphicsCommand> redo = new Stack();
    private GraphicsObject activeObject;
    private JLayeredPane layeredPane;
    private GraphicsEditorGUI gui;
    private List<Class<? extends GraphicsFilter>> availableFilters = new ArrayList<Class<? extends GraphicsFilter>>();
    private Point offset = new Point(0, 0);

    public GraphicsEditor() {
        this.availableFilters.add(ScaleFilter.class);
        this.availableFilters.add(RotateFilter.class);
        this.availableFilters.add(HSBHueFilter.class);
        this.availableFilters.add(HSBBrightnessFilter.class);
        this.availableFilters.add(HSBSaturationFilter.class);
        this.availableFilters.add(ColorChannelBWFilter.class);
        this.availableFilters.add(SelectiveBW.class);
        this.availableFilters.add(OpacityFilter.class);
        this.availableFilters.add(ColorSaturationFilter.class);
        this.availableFilters.add(ColorChannelFilter.class);
        this.availableFilters.add(InvertFilter.class);
        this.availableFilters.add(SimpleBlurFilter.class);
        this.availableFilters.add(GaussianBlur.class);
        this.availableFilters.add(UnsharpMaskFilter.class);
        this.availableFilters.add(PosterizeFilter.class);
    }

    public void doCommand(GraphicsCommand cmd) {
        cmd.redo();
        this.undo.push(cmd);
        this.redo.clear();
    }

    public void addImage(File file) {
        this.doCommand(new GraphicsCommand(file){
            GraphicsObject go;
            {
                this.go = new GraphicsObject(file, GraphicsEditor.this);
            }

            @Override
            public void redo() {
                GraphicsEditor.this.layeredPane.add((Component)this.go, JLayeredPane.DEFAULT_LAYER);
                GraphicsEditor.this.layeredPane.moveToFront(this.go);
                GraphicsEditor.this.setActive(this.go);
            }

            @Override
            public void undo() {
                GraphicsEditor.this.layeredPane.remove(this.go);
                GraphicsEditor.this.layeredPane.repaint();
            }
        });
    }

    public void dupImage() {
        if (this.activeObject == null) {
            return;
        }
        this.doCommand(new GraphicsCommand(){
            GraphicsObject go;
            {
                this.go = new GraphicsObject(GraphicsEditor.this.activeObject.getOriginal(), GraphicsEditor.this.activeObject.getFile(), GraphicsEditor.this);
            }

            @Override
            public void redo() {
                GraphicsEditor.this.layeredPane.add((Component)this.go, JLayeredPane.DEFAULT_LAYER);
                GraphicsEditor.this.layeredPane.moveToFront(this.go);
                GraphicsEditor.this.setActive(this.go);
            }

            @Override
            public void undo() {
                GraphicsEditor.this.layeredPane.remove(this.go);
                GraphicsEditor.this.layeredPane.repaint();
            }
        });
    }

    public void removeImage(final GraphicsObject go) {
        if (go == null) {
            return;
        }
        this.doCommand(new GraphicsCommand(){
            private int pos = -1;

            @Override
            public void redo() {
                this.pos = GraphicsEditor.this.layeredPane.getPosition(go);
                GraphicsEditor.this.layeredPane.remove(go);
                GraphicsEditor.this.layeredPane.repaint();
            }

            @Override
            public void undo() {
                GraphicsEditor.this.layeredPane.add((Component)go, JLayeredPane.DEFAULT_LAYER);
                GraphicsEditor.this.layeredPane.setPosition(go, this.pos);
                GraphicsEditor.this.setActive(go);
            }
        });
    }

    public void saveContent(File output) {
        Object[] options;
        int n;
        if (output.exists() && (n = JOptionPane.showOptionDialog(this.gui, "The filename file already exists. Do you want to overwrite it?", "Overwrite?!", 1, 3, null, options = new Object[]{"Yes", "No", "Cancel"}, options[2])) != 0) {
            return;
        }
        int l = 0;
        int r = 0;
        int o = 0;
        int u = 0;
        Component[] componentArray = this.layeredPane.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Component c = componentArray[n3];
            Rectangle bounds = c.getBounds();
            if (l > bounds.x || l == 0) {
                l = bounds.x;
            }
            if (r < bounds.x + bounds.width || r == 0) {
                r = bounds.x + bounds.width;
            }
            if (o > bounds.y || o == 0) {
                o = bounds.y;
            }
            if (u < bounds.y + bounds.height || u == 0) {
                u = bounds.y + bounds.height;
            }
            ++n3;
        }
        int width = r - l;
        int height = u - o;
        BufferedImage bi = new BufferedImage(width, height, 2);
        int i = this.layeredPane.getComponentCount() - 1;
        while (i > -1) {
            GraphicsObject go = (GraphicsObject)this.layeredPane.getComponent(i);
            Rectangle bounds = go.getBounds();
            bi.getGraphics().drawImage(go.getCurrent(), bounds.x - l, bounds.y - o, null);
            --i;
        }
        try {
            ImageIO.write((RenderedImage)bi, "png", output);
        }
        catch (IOException e) {
            System.err.println("Saving not possible ...");
        }
    }

    public GraphicsObject getActive() {
        return this.activeObject;
    }

    public void setActive(GraphicsObject go) {
        this.cancelFilter();
        this.activeObject = go;
        this.updateActive();
        this.gui.repaint();
    }

    public GraphicsFilter getFilter() {
        if (this.activeObject == null) {
            return null;
        }
        return this.activeObject.getFilter();
    }

    public void setFilter(GraphicsFilter gf) {
        if (this.activeObject == null) {
            return;
        }
        this.activeObject.addFilter(gf);
        gf.assign(this.activeObject);
    }

    public void cancelFilter() {
        if (this.activeObject == null || this.activeObject.getFilter() == null) {
            return;
        }
        this.activeObject.getFilter().remove(this.activeObject);
        this.activeObject.cancelFilter();
    }

    public void applyFilter() {
        if (this.activeObject == null) {
            return;
        }
        this.activeObject.getFilter().remove(this.activeObject);
        this.activeObject.applyFilter();
    }

    public void toFront(final GraphicsObject go) {
        if (go == null) {
            return;
        }
        this.doCommand(new GraphicsCommand(){
            int pos = -1;

            @Override
            public void redo() {
                this.pos = GraphicsEditor.this.layeredPane.getPosition(go);
                GraphicsEditor.this.layeredPane.moveToFront(go);
            }

            @Override
            public void undo() {
                GraphicsEditor.this.layeredPane.setPosition(go, this.pos);
            }
        });
    }

    public void toBack(final GraphicsObject go) {
        if (go == null) {
            return;
        }
        this.doCommand(new GraphicsCommand(){
            int pos = -1;

            @Override
            public void redo() {
                this.pos = GraphicsEditor.this.layeredPane.getPosition(go);
                GraphicsEditor.this.layeredPane.moveToBack(go);
            }

            @Override
            public void undo() {
                GraphicsEditor.this.layeredPane.setPosition(go, this.pos);
            }
        });
    }

    public void updateActive() {
        this.gui.removeFilterSettings();
        this.gui.getActiveLabel().setText(this.activeObject != null ? this.activeObject.toString() : " ");
    }

    public void doUndo() {
        if (this.undo.isEmpty()) {
            return;
        }
        GraphicsCommand cmd = this.undo.pop();
        cmd.undo();
        this.redo.push(cmd);
    }

    public void doRedo() {
        if (this.redo.isEmpty()) {
            return;
        }
        GraphicsCommand cmd = this.redo.pop();
        cmd.redo();
        this.undo.push(cmd);
    }

    public List<Class<? extends GraphicsFilter>> getAvailableFilters() {
        return this.availableFilters;
    }

    public void setOffset(Point o) {
        this.offset = o;
    }

    public Point getOffset() {
        return new Point(this.offset.x, this.offset.y);
    }

    public static void main(String[] args) {
        GraphicsEditor ge = new GraphicsEditor();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphicsEditor.this.gui = new GraphicsEditorGUI(GraphicsEditor.this);
                GraphicsEditor.this.layeredPane = GraphicsEditor.this.gui.getGfxLayeredPane();
                GraphicsEditor.this.gui.setLocationRelativeTo(null);
                GraphicsEditor.this.gui.setVisible(true);
            }
        });
    }
}

