/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class BrightnessFilter
implements GraphicsFilter {
    GraphicsObject go;
    JSlider slider = new JSlider();
    JLabel label;

    public BrightnessFilter() {
        this.slider.setMinimum(-100);
        this.slider.setMaximum(100);
        this.slider.setValue(0);
        this.label = new JLabel("0%");
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        double factor = (double)this.slider.getValue() / 100.0 + 1.0;
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        int i = 0;
        while (i < bi.getWidth()) {
            int j = 0;
            while (j < bi.getHeight()) {
                int argb = bi.getRGB(i, j);
                int alpha = 0xFF000000 & argb;
                int r = (argb & 0xFF0000) >>> 16;
                int g = (argb & 0xFF00) >>> 8;
                int b = argb & 0xFF;
                r = (int)((double)r * factor);
                g = (int)((double)g * factor);
                b = (int)((double)b * factor);
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                biOut.setRGB(i, j, alpha | r << 16 | g << 8 | b);
                ++j;
            }
            ++i;
        }
        return biOut;
    }

    @Override
    public void assign(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void remove(GraphicsObject go) {
        this.go = null;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        parent.add(this.label);
        parent.add(this.slider);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BrightnessFilter.this.label.setText(String.valueOf(BrightnessFilter.this.slider.getValue()) + "%");
                BrightnessFilter.this.go.updateCurrent();
            }
        };
        this.slider.addChangeListener(l);
    }

    public String toString() {
        return "Brightness";
    }
}

