/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class ColorChannelBWFilter
implements GraphicsFilter {
    ButtonGroup buttons = new ButtonGroup();
    JRadioButton radioR = new JRadioButton("red", true);
    JRadioButton radioG = new JRadioButton("green");
    JRadioButton radioB = new JRadioButton("blue");
    GraphicsObject go;

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        int i = 0;
        while (i < bi.getWidth()) {
            int j = 0;
            while (j < bi.getHeight()) {
                int argb = bi.getRGB(i, j);
                int alpha = 0xFF000000 & argb;
                int r = (argb & 0xFF0000) >>> 16;
                int g = (argb & 0xFF00) >>> 8;
                int b = argb & 0xFF;
                if (this.radioR.isSelected()) {
                    g = b = r;
                }
                if (this.radioG.isSelected()) {
                    r = b = g;
                }
                if (this.radioB.isSelected()) {
                    r = g = b;
                }
                biOut.setRGB(i, j, alpha | r << 16 | g << 8 | b);
                ++j;
            }
            ++i;
        }
        return biOut;
    }

    @Override
    public void assign(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void remove(GraphicsObject go) {
        this.go = null;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        this.buttons.add(this.radioR);
        this.buttons.add(this.radioG);
        this.buttons.add(this.radioB);
        parent.add(this.radioR);
        parent.add(this.radioG);
        parent.add(this.radioB);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorChannelBWFilter.this.go.updateCurrent();
            }
        };
        this.radioR.addChangeListener(l);
        this.radioG.addChangeListener(l);
        this.radioB.addChangeListener(l);
    }

    public String toString() {
        return "RGB Channel B/W";
    }
}

