/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class ColorSaturationFilter
implements GraphicsFilter {
    private GraphicsObject go;
    private JSlider redSlider = new JSlider();
    private JSlider greenSlider;
    private JSlider blueSlider;

    public ColorSaturationFilter() {
        this.redSlider.setMaximum(200);
        this.redSlider.setMinimum(0);
        this.redSlider.setValue(100);
        this.greenSlider = new JSlider();
        this.greenSlider.setMaximum(200);
        this.greenSlider.setMinimum(0);
        this.greenSlider.setValue(100);
        this.blueSlider = new JSlider();
        this.blueSlider.setMaximum(200);
        this.blueSlider.setMinimum(0);
        this.blueSlider.setValue(100);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        int r = this.redSlider.getValue();
        int g = this.greenSlider.getValue();
        int b = this.blueSlider.getValue();
        BufferedImage tmp = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        int x = 0;
        while (x < tmp.getWidth()) {
            int y = 0;
            while (y < tmp.getHeight()) {
                int pixel = bi.getRGB(x, y);
                int alpha = pixel >> 24 & 0xFF;
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                if ((red = (int)((double)red * ((double)r / 100.0))) > 255) {
                    red = 255;
                }
                if ((green = (int)((double)green * ((double)g / 100.0))) > 255) {
                    green = 255;
                }
                if ((blue = (int)((double)blue * ((double)b / 100.0))) > 255) {
                    blue = 255;
                }
                tmp.setRGB(x, y, alpha << 24 | red << 16 | green << 8 | blue);
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    @Override
    public void assign(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void remove(GraphicsObject go) {
        this.go = null;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        final JLabel rl = new JLabel("100");
        final JLabel gl = new JLabel("100");
        final JLabel bl = new JLabel("100");
        parent.add(new JLabel("R: "));
        parent.add(this.redSlider);
        parent.add(rl);
        parent.add(new JLabel("G: "));
        parent.add(this.greenSlider);
        parent.add(gl);
        parent.add(new JLabel("B: "));
        parent.add(this.blueSlider);
        parent.add(bl);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                rl.setText(String.valueOf(ColorSaturationFilter.this.redSlider.getValue()));
                gl.setText(String.valueOf(ColorSaturationFilter.this.greenSlider.getValue()));
                bl.setText(String.valueOf(ColorSaturationFilter.this.blueSlider.getValue()));
                ColorSaturationFilter.this.go.updateCurrent();
            }
        };
        this.redSlider.addChangeListener(l);
        this.greenSlider.addChangeListener(l);
        this.blueSlider.addChangeListener(l);
    }

    public String toString() {
        return "RGB Saturation";
    }
}

