/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class GaussianBlur
implements GraphicsFilter {
    JSlider slider = new JSlider();
    JLabel label;
    JCheckBox edges;
    float[][] matrix;
    GraphicsObject go;

    public GaussianBlur() {
        this.slider.setMinimum(50);
        this.slider.setMaximum(200);
        this.slider.setValue(50);
        this.label = new JLabel("radius: 0,5");
        this.edges = new JCheckBox("cut picture?", true);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        this.refreshKernel();
        float[] table = new float[this.matrix.length * this.matrix.length];
        int i = 0;
        while (i < this.matrix.length) {
            System.arraycopy(this.matrix[i], 0, table, i * this.matrix.length, this.matrix.length);
            ++i;
        }
        Kernel kernel = new Kernel(this.matrix.length, this.matrix.length, table);
        ConvolveOp op = new ConvolveOp(kernel, this.edges.isSelected() ? 0 : 1, null);
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        op.filter(bi, biOut);
        return biOut;
    }

    @Override
    public void assign(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void remove(GraphicsObject go) {
        this.go = null;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        parent.add(this.label);
        parent.add(this.slider);
        parent.add(this.edges);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GaussianBlur.this.label.setText("radius: " + (float)GaussianBlur.this.slider.getValue() / 100.0f);
                GaussianBlur.this.go.updateCurrent();
            }
        };
        this.slider.addChangeListener(l);
        this.edges.addChangeListener(l);
    }

    public void refreshKernel() {
        float sd = (float)this.slider.getValue() / 100.0f;
        int dim = (int)Math.ceil(6.0f * sd);
        dim = dim % 2 == 0 ? dim + 1 : dim;
        int offset = (dim - 1) / 2;
        this.matrix = new float[dim][dim];
        int i = 0;
        while (i < this.matrix.length) {
            int j = 0;
            while (j < this.matrix[i].length) {
                this.matrix[i][j] = this.gaussian(sd, i - offset, j - offset);
                ++j;
            }
            ++i;
        }
    }

    public String toString() {
        return "Gaussian Blur";
    }

    private float gaussian(float sd, int x, int y) {
        return (float)(1.0 / (Math.PI * 2 * (double)sd * (double)sd) * Math.exp((float)(-1 * (x * x + y * y)) / (2.0f * sd * sd)));
    }
}

