/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public abstract class HSBFilter
implements GraphicsFilter {
    GraphicsObject go;
    JSlider slider = new JSlider();
    JLabel label;

    protected abstract String getName();

    protected abstract JLabel getHintLabel();

    protected abstract int getIndexHSB();

    public HSBFilter() {
        this.slider.setMinimum(-100);
        this.slider.setMaximum(100);
        this.slider.setValue(0);
        this.label = new JLabel("0%");
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        double factor = (double)this.slider.getValue() / 100.0 + 1.0;
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        int i = 0;
        while (i < bi.getWidth()) {
            int j = 0;
            while (j < bi.getHeight()) {
                int argb = bi.getRGB(i, j);
                int alpha = 0xFF000000 & argb;
                int r = (argb & 0xFF0000) >>> 16;
                int g = (argb & 0xFF00) >>> 8;
                int b = argb & 0xFF;
                float[] hsbvals = new float[3];
                Color.RGBtoHSB(r, g, b, hsbvals);
                float newB = (float)((double)hsbvals[this.getIndexHSB()] * factor);
                hsbvals[this.getIndexHSB()] = newB > 1.0f ? 1.0f : newB;
                biOut.setRGB(i, j, alpha | 0xFFFFFF & Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2]));
                ++j;
            }
            ++i;
        }
        return biOut;
    }

    @Override
    public void assign(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void remove(GraphicsObject go) {
        this.go = null;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel c = new JPanel();
        p.add((Component)this.getHintLabel(), "North");
        c.add(this.label);
        c.add(this.slider);
        p.add((Component)c, "Center");
        parent.add(p);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HSBFilter.this.label.setText(String.valueOf(HSBFilter.this.slider.getValue()) + "%");
                HSBFilter.this.go.updateCurrent();
            }
        };
        this.slider.addChangeListener(l);
    }

    public String toString() {
        return this.getName();
    }
}

