/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class OpacityFilter
implements GraphicsFilter {
    JSlider slider = new JSlider();
    GraphicsObject go;

    public OpacityFilter() {
        this.slider.setMinimum(0);
        this.slider.setMaximum(100);
        this.slider.setValue(100);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        int i = 0;
        while (i < bi.getWidth()) {
            int j = 0;
            while (j < bi.getHeight()) {
                int argb = bi.getRGB(i, j);
                int alpha = (0xFF000000 & argb) >>> 24;
                alpha = (int)((double)this.slider.getValue() / 100.0 * (double)alpha);
                biOut.setRGB(i, j, alpha << 24 | 0xFFFFFF & argb);
                ++j;
            }
            ++i;
        }
        return biOut;
    }

    @Override
    public void assign(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void remove(GraphicsObject go) {
        this.go = null;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        final JLabel label = new JLabel(String.valueOf(this.slider.getValue()) + "%");
        parent.add(label);
        parent.add(this.slider);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                label.setText(String.valueOf(OpacityFilter.this.slider.getValue()) + "%");
                OpacityFilter.this.go.updateCurrent();
            }
        };
        this.slider.addChangeListener(l);
    }

    public String toString() {
        return "Add Transparency";
    }
}

