/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class PosterizeFilter
implements GraphicsFilter {
    GraphicsObject go;
    JSlider slider = new JSlider();
    JLabel label;
    int[] table;

    public PosterizeFilter() {
        this.slider.setMinimum(1);
        this.slider.setMaximum(8);
        this.slider.setValue(2);
        this.label = new JLabel("1 Step");
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        this.resetTable();
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        int i = 0;
        while (i < bi.getWidth()) {
            int j = 0;
            while (j < bi.getHeight()) {
                int argb = bi.getRGB(i, j);
                int alpha = 0xFF000000 & argb;
                int r = (argb & 0xFF0000) >>> 16;
                int g = (argb & 0xFF00) >>> 8;
                int b = argb & 0xFF;
                r = this.table[r];
                g = this.table[g];
                b = this.table[b];
                biOut.setRGB(i, j, alpha | r << 16 | g << 8 | b);
                ++j;
            }
            ++i;
        }
        return biOut;
    }

    @Override
    public void assign(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void remove(GraphicsObject go) {
        this.go = null;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        parent.add(this.label);
        parent.add(this.slider);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int v = PosterizeFilter.this.slider.getValue() - 1;
                PosterizeFilter.this.label.setText(String.valueOf(v) + (v == 1 ? " Step" : " Steps"));
                PosterizeFilter.this.go.updateCurrent();
            }
        };
        this.slider.addChangeListener(l);
    }

    private void resetTable() {
        this.table = new int[256];
        int mergeCounter = 0;
        int lastGood = 0;
        int i = 0;
        while (i < 256) {
            if (mergeCounter == this.slider.getValue() * 8) {
                mergeCounter = 1;
                this.table[i] = i;
                lastGood = i;
            } else {
                this.table[i] = this.table[lastGood];
                ++mergeCounter;
            }
            ++i;
        }
    }

    public String toString() {
        return "Posterize";
    }
}

