/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class RotateFilter
implements GraphicsFilter {
    int radius = 0;
    private MouseWheelListener mwl;
    private JLabel radiusLabel = new JLabel("0\u00b0");

    @Override
    public BufferedImage filter(BufferedImage bi) {
        int y;
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(this.radius), 0.0, 0.0);
        AffineTransformOp ato = new AffineTransformOp(at, 2);
        Rectangle2D bounds = ato.getBounds2D(bi);
        BufferedImage newBi = new BufferedImage(Math.max(bi.getWidth(), (int)bounds.getWidth()), Math.max(bi.getHeight(), (int)bounds.getHeight()), 2);
        BufferedImage tmpBi = new BufferedImage(Math.max(bi.getWidth(), (int)bounds.getWidth()), Math.max(bi.getHeight(), (int)bounds.getHeight()), 2);
        BufferedImage biOut = new BufferedImage((int)bounds.getWidth(), (int)bounds.getHeight(), 2);
        int x = (int)(bounds.getWidth() - (double)bi.getWidth()) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = (int)(bounds.getHeight() - (double)bi.getHeight()) / 2) < 0) {
            y = 0;
        }
        newBi.getGraphics().drawImage(bi, x, y, null);
        at = new AffineTransform();
        at.rotate(Math.toRadians(this.radius), (double)newBi.getWidth() / 2.0, (double)newBi.getHeight() / 2.0);
        ato = new AffineTransformOp(at, 2);
        ato.filter(newBi, tmpBi);
        x = (int)((double)(tmpBi.getWidth() - biOut.getWidth()) / -2.0);
        y = (int)((double)(tmpBi.getHeight() - biOut.getHeight()) / -2.0);
        biOut.getGraphics().drawImage(tmpBi, x, y, null);
        return biOut;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        parent.add(this.radiusLabel);
    }

    @Override
    public void assign(final GraphicsObject go) {
        this.mwl = new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (go.getGraphicsEditor().getActive() != go) {
                    return;
                }
                RotateFilter.this.radius = (RotateFilter.this.radius + (e.getWheelRotation() < 0 ? 10 : -10)) % 360;
                RotateFilter.this.radiusLabel.setText(String.valueOf(RotateFilter.this.radius) + "\u00b0");
                go.updateCurrent();
            }
        };
        go.addMouseWheelListener(this.mwl);
    }

    @Override
    public void remove(GraphicsObject go) {
        go.removeMouseWheelListener(this.mwl);
    }

    public String toString() {
        return "Rotate";
    }
}

