/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class ScaleFilter
implements GraphicsFilter {
    private int ratio = 100;
    private MouseWheelListener mwl;
    private JLabel scaleLabel = new JLabel("100%");

    @Override
    public BufferedImage filter(BufferedImage bi) {
        if (this.ratio == 100) {
            return bi;
        }
        BufferedImage tmp = new BufferedImage((int)((double)(bi.getWidth() * this.ratio) / 100.0), (int)((double)(bi.getHeight() * this.ratio) / 100.0), 2);
        int x = 0;
        while (x < tmp.getWidth()) {
            int y = 0;
            while (y < tmp.getHeight()) {
                tmp.setRGB(x, y, bi.getRGB((int)((double)x * 100.0 / (double)this.ratio), (int)((double)y * 100.0 / (double)this.ratio)));
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    @Override
    public void assign(final GraphicsObject go) {
        this.mwl = new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ScaleFilter scaleFilter = ScaleFilter.this;
                scaleFilter.ratio = scaleFilter.ratio + (e.getWheelRotation() < 0 ? 10 : -10);
                if (ScaleFilter.this.ratio < 10) {
                    ScaleFilter.this.ratio = 10;
                }
                ScaleFilter.this.scaleLabel.setText(String.valueOf(ScaleFilter.this.ratio) + "%");
                go.updateCurrent();
            }
        };
        go.addMouseWheelListener(this.mwl);
    }

    @Override
    public void remove(GraphicsObject go) {
        go.removeMouseWheelListener(this.mwl);
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        parent.add(this.scaleLabel);
    }

    public String toString() {
        return "Scale";
    }
}

