/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsObject;

public class SelectiveBW
implements GraphicsFilter {
    GraphicsObject go;
    JLabel tLabel;
    JSlider threshold = new JSlider();
    JToggleButton pipetSwitch;
    JLabel hint;
    Point goPoint;
    MouseAdapter ma;

    public SelectiveBW() {
        this.threshold.setMinimum(0);
        this.threshold.setMaximum(255);
        this.threshold.setValue(50);
        this.tLabel = new JLabel("threshold: 50");
        this.pipetSwitch = new JToggleButton(new ImageIcon(this.getClass().getResource("/resources/palette.png")));
        this.hint = new JLabel("please click on the palette button");
        this.goPoint = new Point(-1, -1);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        if (this.goPoint.x != -1 && this.goPoint.y != -1) {
            int preserve = bi.getRGB((int)this.goPoint.getX(), (int)this.goPoint.getY());
            int rp = (preserve & 0xFF0000) >>> 16;
            int gp = (preserve & 0xFF00) >>> 8;
            int bp = preserve & 0xFF;
            int t = this.threshold.getValue();
            int i = 0;
            while (i < bi.getWidth()) {
                int j = 0;
                while (j < bi.getHeight()) {
                    int argb = bi.getRGB(i, j);
                    int alpha = 0xFF000000 & argb;
                    int r = (argb & 0xFF0000) >>> 16;
                    int g = (argb & 0xFF00) >>> 8;
                    int b = argb & 0xFF;
                    int bw = (r + g + b) / 3;
                    if (Math.abs(rp - r) < t && Math.abs(gp - g) < t && Math.abs(bp - b) < t) {
                        biOut.setRGB(i, j, alpha | r << 16 | g << 8 | b);
                    } else {
                        biOut.setRGB(i, j, alpha | bw << 16 | bw << 8 | bw);
                    }
                    ++j;
                }
                ++i;
            }
            return biOut;
        }
        return bi;
    }

    @Override
    public void assign(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void remove(GraphicsObject go) {
        this.go.setCursor(new Cursor(0));
        this.go.removeMouseListener(this.ma);
        this.go = null;
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel c = new JPanel();
        p.add((Component)this.hint, "North");
        c.add(this.tLabel);
        c.add(this.threshold);
        c.add(this.pipetSwitch);
        p.add((Component)c, "Center");
        parent.add(p);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectiveBW.this.tLabel.setText("threshold: " + SelectiveBW.this.threshold.getValue());
                SelectiveBW.this.go.updateCurrent();
            }
        };
        ChangeListener pl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectiveBW.this.ma = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        (this).SelectiveBW.this.goPoint = e.getPoint();
                        (this).SelectiveBW.this.go.setCursor(new Cursor(0));
                        (this).SelectiveBW.this.go.removeMouseListener(this);
                        (this).SelectiveBW.this.pipetSwitch.setSelected(false);
                        (this).SelectiveBW.this.hint.setText("adjust threshold at will or choose again");
                        (this).SelectiveBW.this.go.updateCurrent();
                    }
                };
                if (SelectiveBW.this.pipetSwitch.isEnabled()) {
                    SelectiveBW.this.hint.setText("please choose a point in the active graphicobject");
                    SelectiveBW.this.go.addMouseListener(SelectiveBW.this.ma);
                    SelectiveBW.this.go.setCursor(new Cursor(1));
                }
            }
        };
        this.pipetSwitch.addChangeListener(pl);
        this.threshold.addChangeListener(l);
    }

    public String toString() {
        return "Selective B/W";
    }
}

