/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.filter;

import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mms.gfxedit.filter.GaussianBlur;
import mms.gfxedit.graphics.GraphicsObject;

public class UnsharpMaskFilter
extends GaussianBlur {
    JSlider thresholdSlider = new JSlider();
    JLabel thresholdLabel;
    JSlider amountSlider;
    JLabel amountLabel;

    public UnsharpMaskFilter() {
        this.thresholdSlider.setMinimum(0);
        this.thresholdSlider.setMaximum(255);
        this.thresholdSlider.setValue(0);
        this.thresholdLabel = new JLabel("threshold: 0");
        this.amountSlider = new JSlider();
        this.amountSlider.setMinimum(0);
        this.amountSlider.setMaximum(100);
        this.amountSlider.setValue(10);
        this.amountLabel = new JLabel("amount: 0,1");
    }

    @Override
    public void assign(GraphicsObject go) {
        super.assign(go);
    }

    @Override
    public void drawSettingsPanel(JPanel parent) {
        parent.add(this.label);
        parent.add(this.slider);
        parent.add(this.thresholdLabel);
        parent.add(this.thresholdSlider);
        parent.add(this.amountLabel);
        parent.add(this.amountSlider);
        parent.add(this.edges);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UnsharpMaskFilter.this.label.setText("radius: " + (float)UnsharpMaskFilter.this.slider.getValue() / 100.0f);
                UnsharpMaskFilter.this.thresholdLabel.setText("threshold: " + UnsharpMaskFilter.this.thresholdSlider.getValue());
                UnsharpMaskFilter.this.amountLabel.setText("amount: " + (float)UnsharpMaskFilter.this.amountSlider.getValue() / 100.0f);
                UnsharpMaskFilter.this.go.updateCurrent();
            }
        };
        this.slider.addChangeListener(l);
        this.thresholdSlider.addChangeListener(l);
        this.amountSlider.addChangeListener(l);
        this.edges.addChangeListener(l);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage gaussed = super.filter(bi);
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        int t = this.thresholdSlider.getValue();
        float a = (float)this.amountSlider.getValue() / 100.0f;
        a *= 8.0f;
        int i = 0;
        while (i < gaussed.getWidth()) {
            int j = 0;
            while (j < gaussed.getHeight()) {
                int argb1 = bi.getRGB(i, j);
                int argb2 = gaussed.getRGB(i, j);
                int alpha = 0xFF000000 & argb2;
                int r1 = (argb1 & 0xFF0000) >>> 16;
                int g1 = (argb1 & 0xFF00) >>> 8;
                int b1 = argb1 & 0xFF;
                int r2 = (argb2 & 0xFF0000) >>> 16;
                int g2 = (argb2 & 0xFF00) >>> 8;
                int b2 = argb2 & 0xFF;
                int r = r1;
                int g = g1;
                int b = b1;
                if (Math.abs(r2 - r1) >= t) {
                    r = (int)((float)r1 + (float)(r1 - r2) * (a + 1.0f));
                }
                if (Math.abs(g2 - g1) >= t) {
                    g = (int)((float)g1 + (float)(g1 - g2) * (a + 1.0f));
                }
                if (Math.abs(b2 - b1) >= t) {
                    b = (int)((float)b1 + (float)(b1 - b2) * (a + 1.0f));
                }
                r = this.trim(r);
                g = this.trim(g);
                b = this.trim(b);
                biOut.setRGB(i, j, alpha | r << 16 | g << 8 | b);
                ++j;
            }
            ++i;
        }
        return biOut;
    }

    private int trim(int i) {
        if (i > 255) {
            return 255;
        }
        if (i < 0) {
            return 0;
        }
        return i;
    }

    @Override
    public void remove(GraphicsObject go) {
        super.remove(go);
    }

    @Override
    public String toString() {
        return "Unsharp Mask";
    }
}

