/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.graphics;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import mms.gfxedit.graphics.GraphicsCommand;
import mms.gfxedit.graphics.GraphicsObject;

public class GraphicsMouseAdapter
extends MouseAdapter {
    private GraphicsObject go;
    private Point mousePressedPoint;
    private Point oldOffset;
    private Rectangle boundsOld;
    private Rectangle boundsNew;
    private boolean isHover = false;

    public GraphicsMouseAdapter(GraphicsObject go) {
        this.go = go;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isHover = true;
        this.go.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isHover = false;
        this.go.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressedPoint = new Point(e.getXOnScreen(), e.getYOnScreen());
        this.boundsNew = this.go.getBounds();
        this.boundsOld = this.go.getBounds();
        this.oldOffset = new Point(this.boundsNew.x, this.boundsNew.y);
        if (this.go.getGraphicsEditor().getActive() != this.go) {
            this.go.getGraphicsEditor().setActive(this.go);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = new Point(e.getXOnScreen(), e.getYOnScreen());
        this.boundsNew = this.go.getBounds();
        this.boundsNew.x = this.oldOffset.x + p.x - this.mousePressedPoint.x;
        this.boundsNew.y = this.oldOffset.y + p.y - this.mousePressedPoint.y;
        this.go.setBounds(this.boundsNew);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.boundsNew.equals(this.boundsOld)) {
            return;
        }
        this.go.getGraphicsEditor().doCommand(new GraphicsCommand(){
            Rectangle bo;
            Rectangle bn;
            {
                this.bo = GraphicsMouseAdapter.this.boundsOld.getBounds();
                this.bn = GraphicsMouseAdapter.this.boundsNew.getBounds();
            }

            @Override
            public void redo() {
                GraphicsMouseAdapter.this.go.setBounds(this.bn);
                GraphicsMouseAdapter.this.go.updateCurrent();
            }

            @Override
            public void undo() {
                GraphicsMouseAdapter.this.go.setBounds(this.bo);
                GraphicsMouseAdapter.this.go.updateCurrent();
            }
        });
        this.go.updateCurrent();
    }

    public boolean isHover() {
        return this.isHover;
    }
}

