/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import mms.gfxedit.GraphicsEditor;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsChangedEvent;
import mms.gfxedit.graphics.GraphicsChangedListener;
import mms.gfxedit.graphics.GraphicsCommand;
import mms.gfxedit.graphics.GraphicsMouseAdapter;

public class GraphicsObject
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GraphicsEditor ge;
    private File file;
    private BufferedImage original;
    private BufferedImage current;
    private GraphicsFilter activeFilter = null;
    private GraphicsMouseAdapter mouseAdapter;
    private List<GraphicsChangedListener> listeners = new ArrayList<GraphicsChangedListener>();
    private Point offset;

    public GraphicsObject(File file, GraphicsEditor ge) {
        this.file = file;
        this.ge = ge;
        this.original = GraphicsObject.getImageByFile(file);
        this.init();
    }

    public GraphicsObject(BufferedImage orig, File file, GraphicsEditor ge) {
        this.file = file;
        this.ge = ge;
        this.original = orig;
        this.init();
    }

    private void init() {
        this.setBounds(new Rectangle(this.original.getWidth() / 2, this.original.getHeight() / 2, 0, 0));
        this.setOpaque(false);
        this.mouseAdapter = new GraphicsMouseAdapter(this);
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        this.offset = this.ge.getOffset();
        this.updateCurrent();
    }

    public void updateCurrent() {
        this.current = new BufferedImage(this.original.getWidth(), this.original.getHeight(), 2);
        this.current.getGraphics().drawImage(this.original, 0, 0, null);
        if (this.activeFilter != null) {
            this.current = this.activeFilter.filter(this.current);
        }
        Rectangle r = this.getBounds();
        this.setBounds(new Rectangle(r.x + (r.width - this.current.getWidth()) / 2, r.y + (r.height - this.current.getHeight()) / 2, this.current.getWidth(), this.current.getHeight()));
        this.fireGraphicsChangedEvent();
    }

    public void addFilter(GraphicsFilter f) {
        this.activeFilter = f;
        this.updateCurrent();
    }

    public GraphicsFilter getFilter() {
        return this.activeFilter;
    }

    public void applyFilter() {
        if (this.activeFilter == null) {
            return;
        }
        BufferedImage tmp = new BufferedImage(this.original.getWidth(), this.original.getHeight(), 2);
        tmp.getGraphics().drawImage(this.original, 0, 0, null);
        this.ge.doCommand(new GraphicsCommand(tmp){
            BufferedImage origbi;
            BufferedImage newbi;
            {
                this.origbi = bufferedImage;
                this.newbi = GraphicsObject.this.activeFilter.filter(bufferedImage);
            }

            @Override
            public void redo() {
                GraphicsObject.this.original = this.newbi;
                GraphicsObject.this.activeFilter = null;
                GraphicsObject.this.updateCurrent();
                GraphicsObject.this.repaint();
            }

            @Override
            public void undo() {
                GraphicsObject.this.original = this.origbi;
                GraphicsObject.this.activeFilter = null;
                GraphicsObject.this.updateCurrent();
                GraphicsObject.this.repaint();
            }
        });
    }

    public void cancelFilter() {
        this.activeFilter = null;
        this.updateCurrent();
    }

    public BufferedImage getCurrent() {
        return this.current;
    }

    public BufferedImage getOriginal() {
        return this.original;
    }

    public void setOriginal(BufferedImage bi) {
        this.original = bi;
        this.updateCurrent();
    }

    public File getFile() {
        return this.file;
    }

    public void addGraphicsChangedListener(GraphicsChangedListener l) {
        this.listeners.add(l);
    }

    public void removeGraphicChangedListener(GraphicsChangedListener l) {
        this.listeners.remove(l);
    }

    private void fireGraphicsChangedEvent() {
        GraphicsChangedEvent e = new GraphicsChangedEvent(this);
        for (GraphicsChangedListener l : this.listeners) {
            l.graphicsChanged(e);
        }
    }

    public GraphicsEditor getGraphicsEditor() {
        return this.ge;
    }

    @Override
    public void repaint() {
        try {
            Point old = this.offset;
            this.offset = this.ge.getOffset();
            Rectangle bounds = this.getBounds();
            bounds.x += this.offset.x - old.x;
            bounds.y += this.offset.y - old.y;
            this.setBounds(bounds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mouseAdapter.isHover()) {
            this.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        } else if (this.ge.getActive() == this) {
            this.setBorder(BorderFactory.createLineBorder(Color.GREEN, 2));
        } else {
            this.setBorder(null);
        }
        g.drawImage(this.current, 0, 0, null);
        super.paintComponent(g);
    }

    @Override
    public int getWidth() {
        return this.current.getWidth();
    }

    @Override
    public int getHeight() {
        return this.current.getHeight();
    }

    @Override
    public String toString() {
        return this.file.getName();
    }

    private static BufferedImage getImageByFile(File file) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(file);
        }
        catch (Exception e) {
            System.err.println("Error during loading image '" + file.getPath() + "'.");
        }
        return image;
    }
}

