/*
 * Decompiled with CFR 0.152.
 */
package mms.gfxedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import mms.gfxedit.GraphicsEditor;
import mms.gfxedit.filter.GraphicsFilter;
import mms.gfxedit.graphics.GraphicsChangedEvent;
import mms.gfxedit.graphics.GraphicsChangedListener;
import mms.gfxedit.graphics.GraphicsObject;
import mms.gfxedit.gui.ImageFileFilter;

public class GraphicsEditorGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GraphicsEditor ge;
    private final JFileChooser fc;
    Point mousePressedPoint = new Point(0, 0);
    Point oldOffset = new Point(0, 0);
    Point curOffset = new Point(0, 0);
    private JButton jButton1;
    private JButton jButtonAddFilter;
    private JButton jButtonApplyFilter;
    private JButton jButtonCancelFilter;
    private JButton jButtonImport;
    private JButton jButtonListenerWindow;
    private JButton jButtonRedo;
    private JButton jButtonRemove;
    private JButton jButtonSave;
    private JButton jButtonToBack;
    private JButton jButtonToFront;
    private JButton jButtonUndo;
    private JComboBox jComboBoxFilters;
    private JLabel jLabelActiveFilter;
    private JLabel jLabelActiveGraphicsPanel;
    private JLabel jLabelFilter;
    private JLabel jLabelFilterSettings;
    private JLayeredPane jLayeredPaneContent;
    private JPanel jPanelActiveFilter;
    private JPanel jPanelActiveGraphicsPanel;
    private JPanel jPanelBottom;
    private JPanel jPanelFilterSettings;
    private JPanel jPanelFilterSettingsButtons;
    private JPanel jPanelFilterSettingsMain;
    private JPanel jPanelFilterSettingsStuff;
    private JPanel jPanelMain;
    private JPanel jPanelTop;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JToolBar.Separator jSeparator9;
    private JToolBar jToolBarFilters;
    private JToolBar jToolBarTop;

    public GraphicsEditorGUI(GraphicsEditor ge) {
        this.ge = ge;
        this.initComponents();
        this.fc = new JFileChooser();
        this.fc.addChoosableFileFilter(new ImageFileFilter());
        this.jPanelFilterSettings.setVisible(false);
    }

    private void initComponents() {
        this.jPanelTop = new JPanel();
        this.jToolBarTop = new JToolBar();
        this.jSeparator8 = new JToolBar.Separator();
        this.jButtonSave = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonImport = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRemove = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonUndo = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButtonRedo = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.jButtonToFront = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.jButtonToBack = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.jButton1 = new JButton();
        this.jSeparator10 = new JToolBar.Separator();
        this.jButtonListenerWindow = new JButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.jToolBarFilters = new JToolBar();
        this.jLabelFilter = new JLabel();
        this.jComboBoxFilters = new JComboBox();
        this.jComboBoxFilters.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.jButtonAddFilter = new JButton();
        this.jSeparator9 = new JToolBar.Separator();
        this.jPanelMain = new JPanel();
        this.jLayeredPaneContent = new JLayeredPane();
        this.jPanelFilterSettings = new JPanel();
        this.jPanelFilterSettingsMain = new JPanel();
        this.jLabelFilterSettings = new JLabel();
        this.jPanelFilterSettingsStuff = new JPanel();
        this.jPanelFilterSettingsButtons = new JPanel();
        this.jButtonApplyFilter = new JButton();
        this.jButtonCancelFilter = new JButton();
        this.jPanelBottom = new JPanel();
        this.jPanelActiveGraphicsPanel = new JPanel();
        this.jLabelActiveGraphicsPanel = new JLabel();
        this.jPanelActiveFilter = new JPanel();
        this.jLabelActiveFilter = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("GraphicsEditor");
        this.setMinimumSize(new Dimension(800, 600));
        this.jPanelTop.setLayout(new BoxLayout(this.jPanelTop, 2));
        this.jToolBarTop.setFloatable(false);
        this.jToolBarTop.setRollover(true);
        this.jToolBarTop.add(this.jSeparator8);
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/resources/disk.png")));
        this.jButtonSave.setText("save");
        this.jButtonSave.setFocusable(false);
        this.jButtonSave.setHorizontalTextPosition(4);
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButtonSave);
        this.jToolBarTop.add(this.jSeparator1);
        this.jButtonImport.setIcon(new ImageIcon(this.getClass().getResource("/resources/image_add.png")));
        this.jButtonImport.setText("import");
        this.jButtonImport.setFocusable(false);
        this.jButtonImport.setHorizontalTextPosition(4);
        this.jButtonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonImportActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButtonImport);
        this.jToolBarTop.add(this.jSeparator2);
        this.jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/resources/image_delete.png")));
        this.jButtonRemove.setText("remove");
        this.jButtonRemove.setFocusable(false);
        this.jButtonRemove.setHorizontalTextPosition(4);
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButtonRemove);
        this.jToolBarTop.add(this.jSeparator3);
        this.jButtonUndo.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_undo.png")));
        this.jButtonUndo.setText("undo");
        this.jButtonUndo.setFocusable(false);
        this.jButtonUndo.setHorizontalTextPosition(4);
        this.jButtonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonUndoActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButtonUndo);
        this.jToolBarTop.add(this.jSeparator4);
        this.jButtonRedo.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_redo.png")));
        this.jButtonRedo.setText("redo");
        this.jButtonRedo.setFocusable(false);
        this.jButtonRedo.setHorizontalTextPosition(4);
        this.jButtonRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonRedoActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButtonRedo);
        this.jToolBarTop.add(this.jSeparator5);
        this.jButtonToFront.setIcon(new ImageIcon(this.getClass().getResource("/resources/shape_move_forwards.png")));
        this.jButtonToFront.setText("to front");
        this.jButtonToFront.setFocusable(false);
        this.jButtonToFront.setHorizontalTextPosition(4);
        this.jButtonToFront.setVerticalTextPosition(3);
        this.jButtonToFront.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonToFrontActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButtonToFront);
        this.jToolBarTop.add(this.jSeparator6);
        this.jButtonToBack.setIcon(new ImageIcon(this.getClass().getResource("/resources/shape_move_backwards.png")));
        this.jButtonToBack.setText("to back");
        this.jButtonToBack.setFocusable(false);
        this.jButtonToBack.setHorizontalTextPosition(4);
        this.jButtonToBack.setVerticalTextPosition(3);
        this.jButtonToBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonToBackActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButtonToBack);
        this.jToolBarTop.add(this.jSeparator7);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/resources/images.png")));
        this.jButton1.setText("dup");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(4);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButton1);
        this.jToolBarTop.add(this.jSeparator10);
        this.jButtonListenerWindow.setIcon(new ImageIcon(this.getClass().getResource("/resources/application.png")));
        this.jButtonListenerWindow.setFocusable(false);
        this.jButtonListenerWindow.setHorizontalTextPosition(0);
        this.jButtonListenerWindow.setVerticalTextPosition(3);
        this.jButtonListenerWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonListenerWindowActionPerformed(evt);
            }
        });
        this.jToolBarTop.add(this.jButtonListenerWindow);
        this.jToolBarTop.add(this.jSeparator11);
        this.jPanelTop.add(this.jToolBarTop);
        this.jToolBarFilters.setFloatable(false);
        this.jToolBarFilters.setRollover(true);
        this.jLabelFilter.setText("Filter: ");
        this.jToolBarFilters.add(this.jLabelFilter);
        this.jComboBoxFilters.setModel(this.getFiltersComboBoxModel());
        this.jComboBoxFilters.setFocusTraversalKeysEnabled(false);
        this.jComboBoxFilters.setFocusable(false);
        this.jComboBoxFilters.setPreferredSize(new Dimension(200, 27));
        this.jToolBarFilters.add(this.jComboBoxFilters);
        this.jButtonAddFilter.setIcon(new ImageIcon(this.getClass().getResource("/resources/add.png")));
        this.jButtonAddFilter.setText("add");
        this.jButtonAddFilter.setFocusable(false);
        this.jButtonAddFilter.setHorizontalTextPosition(4);
        this.jButtonAddFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonAddFilterActionPerformed(evt);
            }
        });
        this.jToolBarFilters.add(this.jButtonAddFilter);
        this.jToolBarFilters.add(this.jSeparator9);
        this.jPanelTop.add(this.jToolBarFilters);
        this.getContentPane().add((Component)this.jPanelTop, "North");
        this.jPanelMain.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jPanelMain.setLayout(new BorderLayout());
        this.jLayeredPaneContent.setBackground(new Color(255, 255, 255));
        this.jLayeredPaneContent.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder));
        this.jLayeredPaneContent.setOpaque(true);
        this.jLayeredPaneContent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GraphicsEditorGUI.this.jLayeredPaneContentMousePressed(evt);
            }
        });
        this.jLayeredPaneContent.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                GraphicsEditorGUI.this.jLayeredPaneContentMouseDragged(evt);
            }
        });
        this.jPanelMain.add((Component)this.jLayeredPaneContent, "Center");
        this.jPanelFilterSettings.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.jPanelFilterSettings.setLayout(new BorderLayout());
        this.jPanelFilterSettingsMain.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder));
        this.jPanelFilterSettingsMain.setLayout(new BorderLayout());
        this.jLabelFilterSettings.setText("<html><b>Filter settings:");
        this.jLabelFilterSettings.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jPanelFilterSettingsMain.add((Component)this.jLabelFilterSettings, "North");
        this.jPanelFilterSettingsMain.add((Component)this.jPanelFilterSettingsStuff, "Center");
        this.jPanelFilterSettingsButtons.setLayout(new GridLayout(1, 2));
        this.jButtonApplyFilter.setIcon(new ImageIcon(this.getClass().getResource("/resources/accept.png")));
        this.jButtonApplyFilter.setText("apply");
        this.jButtonApplyFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonApplyFilterActionPerformed(evt);
            }
        });
        this.jPanelFilterSettingsButtons.add(this.jButtonApplyFilter);
        this.jButtonCancelFilter.setIcon(new ImageIcon(this.getClass().getResource("/resources/cancel.png")));
        this.jButtonCancelFilter.setText("cancel");
        this.jButtonCancelFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsEditorGUI.this.jButtonCancelFilterActionPerformed(evt);
            }
        });
        this.jPanelFilterSettingsButtons.add(this.jButtonCancelFilter);
        this.jPanelFilterSettingsMain.add((Component)this.jPanelFilterSettingsButtons, "South");
        this.jPanelFilterSettings.add((Component)this.jPanelFilterSettingsMain, "Center");
        this.jPanelMain.add((Component)this.jPanelFilterSettings, "Last");
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelBottom.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jPanelBottom.setLayout(new GridLayout(1, 0, 2, 0));
        this.jPanelActiveGraphicsPanel.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("windowBorder")));
        this.jPanelActiveGraphicsPanel.setLayout(new BorderLayout());
        this.jLabelActiveGraphicsPanel.setText(" ");
        this.jLabelActiveGraphicsPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.jPanelActiveGraphicsPanel.add((Component)this.jLabelActiveGraphicsPanel, "Center");
        this.jPanelBottom.add(this.jPanelActiveGraphicsPanel);
        this.jPanelActiveFilter.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("windowBorder")));
        this.jPanelActiveFilter.setLayout(new BorderLayout());
        this.jLabelActiveFilter.setText(" ");
        this.jLabelActiveFilter.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.jPanelActiveFilter.add((Component)this.jLabelActiveFilter, "Center");
        this.jPanelBottom.add(this.jPanelActiveFilter);
        this.getContentPane().add((Component)this.jPanelBottom, "Last");
        this.pack();
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null) {
            return;
        }
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            this.ge.addImage(file);
        }
    }

    private void jButtonUndoActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null) {
            return;
        }
        this.ge.doUndo();
    }

    private void jLayeredPaneContentMousePressed(MouseEvent evt) {
        if (this.ge.getActive() != null) {
            this.jButtonCancelFilterActionPerformed(null);
        }
        this.ge.setActive(null);
        this.mousePressedPoint = new Point(evt.getXOnScreen(), evt.getYOnScreen());
        this.oldOffset = this.curOffset;
    }

    private void jLayeredPaneContentMouseDragged(MouseEvent evt) {
        Point p = new Point(evt.getXOnScreen(), evt.getYOnScreen());
        this.curOffset = new Point(0, 0);
        this.curOffset.x = this.oldOffset.x + p.x - this.mousePressedPoint.x;
        this.curOffset.y = this.oldOffset.y + p.y - this.mousePressedPoint.y;
        this.ge.setOffset(this.curOffset);
        Component[] componentArray = this.jLayeredPaneContent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component go = componentArray[n2];
            go.repaint();
            ++n2;
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null) {
            return;
        }
        this.ge.removeImage(this.ge.getActive());
    }

    private void jButtonAddFilterActionPerformed(ActionEvent evt) {
        if (this.ge.getActive() == null && this.ge.getFilter() == null) {
            return;
        }
        GraphicsFilter gf = null;
        try {
            gf = (GraphicsFilter)this.jComboBoxFilters.getSelectedItem().getClass().newInstance();
        }
        catch (Exception e) {
            return;
        }
        this.ge.setFilter(gf);
        this.jPanelFilterSettingsStuff.removeAll();
        gf.drawSettingsPanel(this.jPanelFilterSettingsStuff);
        this.jPanelFilterSettings.setVisible(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null) {
            return;
        }
        int returnVal = this.fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            this.ge.saveContent(file);
        }
    }

    private void jButtonToFrontActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null) {
            return;
        }
        this.ge.toFront(this.ge.getActive());
    }

    private void jButtonToBackActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null) {
            return;
        }
        this.ge.toBack(this.ge.getActive());
    }

    private void jButtonRedoActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null) {
            return;
        }
        this.ge.doRedo();
    }

    private void jButtonApplyFilterActionPerformed(ActionEvent evt) {
        this.ge.applyFilter();
        this.jPanelFilterSettingsStuff.removeAll();
        this.jPanelFilterSettings.setVisible(false);
    }

    private void jButtonCancelFilterActionPerformed(ActionEvent evt) {
        this.ge.cancelFilter();
        this.removeFilterSettings();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null) {
            return;
        }
        this.ge.dupImage();
    }

    private void jButtonListenerWindowActionPerformed(ActionEvent evt) {
        if (this.ge.getFilter() != null || this.ge.getActive() == null) {
            return;
        }
        final GraphicsObject go = this.ge.getActive();
        JDialog lw = new JDialog((Frame)this, "BoundsInfo: " + go.getFile().getName());
        lw.setDefaultCloseOperation(2);
        lw.setPreferredSize(new Dimension(300, 50));
        final JLabel il = new JLabel();
        lw.getContentPane().add(il);
        go.addGraphicsChangedListener(new GraphicsChangedListener(){

            @Override
            public void graphicsChanged(GraphicsChangedEvent e) {
                Rectangle bounds = go.getBounds();
                il.setText(" (x: " + bounds.x + ", y: " + bounds.y + ") -> [" + bounds.width + "px x " + bounds.height + "px]");
            }
        });
        go.updateCurrent();
        lw.pack();
        lw.setLocationRelativeTo(null);
        lw.setVisible(true);
    }

    public DefaultComboBoxModel getFiltersComboBoxModel() {
        ArrayList<GraphicsFilter> names = new ArrayList<GraphicsFilter>();
        for (Class<? extends GraphicsFilter> c : this.ge.getAvailableFilters()) {
            try {
                GraphicsFilter gf = c.newInstance();
                names.add(gf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DefaultComboBoxModel<GraphicsFilter>(names.toArray(new GraphicsFilter[names.size()]));
    }

    public JLayeredPane getGfxLayeredPane() {
        return this.jLayeredPaneContent;
    }

    public JLabel getActiveLabel() {
        return this.jLabelActiveGraphicsPanel;
    }

    public void removeFilterSettings() {
        this.jPanelFilterSettingsStuff.removeAll();
        this.jPanelFilterSettings.repaint();
        this.jPanelFilterSettings.setVisible(false);
    }
}

