/*
 * Decompiled with CFR 0.152.
 */
package tetrisfx;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import tetrisfx.TetrisFX;

public class Tetromino
extends Group {
    public static final int SQUARE_SIZE = 30;
    public static final int OFFSET = 22;
    public final Shape shape;
    public final int[][] coords;
    public final Point position = new Point(0, 0);
    public final List<Square> squares = new ArrayList<Square>(){
        {
            this.add(new Square());
            this.add(new Square());
            this.add(new Square());
            this.add(new Square());
        }
    };
    private final TetrisFX game;

    public Tetromino(TetrisFX g, Shape s) {
        this.shape = s;
        this.coords = new int[s.coords.length][s.coords[0].length];
        for (int i = 0; i < s.coords.length; ++i) {
            System.arraycopy(s.coords[i], 0, this.coords[i], 0, s.coords[i].length);
        }
        this.game = g;
        this.translate(4, 0);
        this.getChildren().addAll(this.squares);
    }

    private Shape getRandomShape() {
        Random r = new Random();
        Shape[] tetrominoes = Shape.values();
        return tetrominoes[Math.abs(r.nextInt()) % (tetrominoes.length - 1) + 1];
    }

    public Point rotate() {
        Point p;
        int i;
        if (this.shape == Shape.O) {
            return this.position;
        }
        for (i = 0; i < 4; ++i) {
            p = this.getCoords(i);
            int w = this.position.x - p.y;
            int v = this.position.y + p.x;
            try {
                if (this.game.grid.get(19 - v)[w] == null) continue;
                return this.position;
            }
            catch (Exception e) {
                if (19 - v >= 0) continue;
                return this.position;
            }
        }
        for (i = 0; i < 4; ++i) {
            p = this.getCoords(i);
            int nx = this.position.x - p.y;
            if (nx < 0) {
                this.position.translate(1, 0);
            } else if (nx > 9) {
                this.position.translate(-1, 0);
            }
            this.setCoords(i, new Point(-p.y, p.x));
        }
        this.update();
        return this.position;
    }

    public void update() {
        for (int i = 0; i < 4; ++i) {
            Square s = this.squares.get(i);
            Point p = this.getCoords(i);
            s.setShape(this.shape);
            s.setX(p.x * 30);
            s.setY(p.y * 30);
        }
        this.setTranslateX(this.position.x * 30 + 22);
        this.setTranslateY(this.position.y * 30 + 22);
    }

    public Point getPosition() {
        return this.position;
    }

    public Point getCoords(int i) {
        return new Point(this.coords[i][0], this.coords[i][1]);
    }

    public void setCoords(int i, Point c) {
        this.coords[i][0] = c.x;
        this.coords[i][1] = c.y;
    }

    public final boolean translate(int x, int y) {
        for (int i = 0; i < 4; ++i) {
            Point p = this.getCoords(i);
            int w = this.position.x + p.x + x;
            int v = this.position.y + p.y + y;
            if (w < 0 || w > 9) {
                return false;
            }
            if (v > 19) {
                return false;
            }
            try {
                if (this.game.grid.get(19 - v)[w] == null) continue;
                return false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.position.translate(x, y);
        this.update();
        return true;
    }

    public void dropDown() {
        while (this.translate(0, 1)) {
        }
    }

    public static class Square
    extends Rectangle {
        public Square() {
            this.setWidth(30.0);
            this.setHeight(30.0);
            this.setFill((Paint)Color.TRANSPARENT);
            this.setStroke((Paint)Color.TRANSPARENT);
            this.setStrokeWidth(4.0);
        }

        public void setShape(Shape shape) {
            if (shape == null) {
                this.setFill((Paint)Color.TRANSPARENT);
                this.setStroke((Paint)Color.TRANSPARENT);
                return;
            }
            this.setFill((Paint)shape.color);
            this.setStroke((Paint)Color.BLACK);
        }
    }

    public static enum Shape {
        Z(new int[][]{{1, 0}, {0, 0}, {0, -1}, {-1, -1}}, Color.RED),
        S(new int[][]{{1, 0}, {0, 0}, {0, 1}, {-1, 1}}, Color.GREEN),
        I(new int[][]{{1, 0}, {0, 0}, {-1, 0}, {-2, 0}}, Color.TURQUOISE),
        T(new int[][]{{1, 0}, {0, 0}, {-1, 0}, {0, -1}}, Color.PINK),
        O(new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}}, Color.YELLOW),
        L(new int[][]{{1, -1}, {1, 0}, {0, 0}, {-1, 0}}, Color.ORANGE),
        J(new int[][]{{-1, -1}, {-1, 0}, {0, 0}, {1, 0}}, Color.BLUE);

        public final int[][] coords;
        public final Color color;

        private Shape(int[][] coords, Color color) {
            this.coords = coords;
            this.color = color;
        }
    }
}

